/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2010 Apogee Instruments, Inc. 
* \class CamGen2CcdAcqParams 
* \brief derived class for managing the Ascent and Aspen camera's ADCs, horizontal pattern files, and roi parameters
* 
*/ 


#ifndef CAMGEN2CCDACQPARAMS_INCLUDE_H__ 
#define CAMGEN2CCDACQPARAMS_INCLUDE_H__ 

#include "CcdAcqParams.h" 

#include <string>
#include <map>
#include <utility>

class CamGen2CcdAcqParams : public CcdAcqParams
{ 
    public: 
        struct AdcParams
        {
            uint16_t selectMask;
            uint16_t channelGainAddr;
            uint16_t channelOffsetAddr;
            uint16_t gain;
            uint16_t offset;
        };

        CamGen2CcdAcqParams(std::tr1::shared_ptr<CApnCamData> & camData,
            std::tr1::shared_ptr<CameraIo> & camIo, std::tr1::shared_ptr<PlatformData> & platformData);
        virtual ~CamGen2CcdAcqParams(); 

        void Init();

      void SetResolution( Apg::Resolution res );

        void SetSpeed( Apg::AdcSpeed speed );

        void SetAdcGain( uint16_t gain, int32_t ad, int32_t channel );
        uint16_t GetAdcGain( int32_t ad, int32_t channel );
        void SetAdcOffset( uint16_t offset, int32_t ad, int32_t channel );
        uint16_t GetAdcOffset( int32_t ad, int32_t channel );

       bool IsAdsSimModeOn();
       uint16_t GetPixelShift();

       uint16_t GetOddColsAdjust();

    protected:
        uint16_t GetCcdImgRows();
        uint16_t GetCcdImgCols();
        uint16_t GetCcdImgBinRows();
        uint16_t GetCcdImgBinCols();
        uint16_t GetTotalCcdCols();
        uint16_t CalcHPostRoiSkip(uint16_t HPreRoiSkip,
            uint16_t UnbinnedRoiCols );
        bool IsColCalcGood( uint16_t UnbinnedRoiCols, uint16_t PreRoiSkip, 
            uint16_t PostRoiSkip);
        
        CamCfg::APN_HPATTERN_FILE GetHPattern( Apg::AdcSpeed speed,
            CcdAcqParams::HPatternType ptype );

    private:
        std::string m_fileName;

        std::map< std::pair<int32_t, int32_t>, 
            CamGen2CcdAcqParams::AdcParams > m_adcParamMap;

        CamGen2CcdAcqParams::AdcParams GetAdcParams( int32_t ad, int32_t channel );
        void SetAdcParams( int32_t ad, int32_t channel, 
            const CamGen2CcdAcqParams::AdcParams & params );

        void SetAdcCfgAndMux( int32_t ad, int32_t channel );
       
        void Write2AdcReg( uint16_t value2Write );

        uint16_t SelectAd( int32_t ad, int32_t channel );
        void RestoreAdSelect( const uint16_t value );

        
        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        CamGen2CcdAcqParams(const CamGen2CcdAcqParams&);
        CamGen2CcdAcqParams& operator=(CamGen2CcdAcqParams&);

}; 

#endif
