/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class Gee 
* \brief Derived class for the alta g series cameras 
* 
*/ 


#ifndef GEE_INCLUDE_H__ 
#define GEE_INCLUDE_H__ 

#include "CamGen2Base.h" 
#include <string>

class DLL_EXPORT Gee : public CamGen2Base
{ 
    public: 
        Gee();

        virtual ~Gee(); 

        void OpenConnection( const std::string & ioType,
             const std::string & DeviceAddr,
             const uint16_t FirmwareRev,
             const uint16_t Id );

        void CloseConnection();

        void StartExposure( double Duration, bool IsLight );

        int32_t GetNumAdChannels();

        double GetTempHeatsink();

		/*! 
         * Returns an ethernet's camera MAC address.  Will throw
         * an std::runtime_error exception if the call is made on a
         * USB camera.
         * \exception std::runtime_error
         */
        std::string GetMacAddress();

        void Init();
 
    protected:
        Gee(const std::string & ioType,
             const std::string & DeviceAddr);


        void FixImgFromCamera( const std::vector<uint16_t> & data,
            std::vector<uint16_t> & out,  int32_t rows, int32_t cols );

        void CreateCamIo(const std::string & ioType,
            const std::string & DeviceAddr);

        void ExposureAndGetImgRC(uint16_t & r, uint16_t & c);

    private:
        

        void CfgCamFromId( uint16_t CameraId );

        const std::string m_fileName;

        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        Gee(const Gee&);
        Gee& operator=(Gee&);
}; 

#endif