/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import java.io.File;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class ImageTest {
    @Test
    public void test() throws Exception {
        Fits f = new Fits();
        byte[][] bimg = new byte[40][40];
        for (int i = 10; i < 30; ++i) {
            for (int j = 10; j < 30; ++j) {
                bimg[i][j] = (byte)(i + j);
            }
        }
        short[][] simg = (short[][])ArrayFuncs.convertArray(bimg, Short.TYPE);
        int[][] iimg = (int[][])ArrayFuncs.convertArray(bimg, Integer.TYPE);
        long[][] limg = (long[][])ArrayFuncs.convertArray(bimg, Long.TYPE);
        float[][] fimg = (float[][])ArrayFuncs.convertArray(bimg, Float.TYPE);
        double[][] dimg = (double[][])ArrayFuncs.convertArray(bimg, Double.TYPE);
        int[][][] img3 = new int[10][20][30];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 20; ++j) {
                for (int k = 0; k < 30; ++k) {
                    img3[i][j][k] = i + j + k;
                }
            }
        }
        double[] img1 = (double[])ArrayFuncs.flatten(dimg);
        f.addHDU(Fits.makeHDU(bimg));
        f.addHDU(Fits.makeHDU(simg));
        f.addHDU(Fits.makeHDU(iimg));
        f.addHDU(Fits.makeHDU(limg));
        f.addHDU(Fits.makeHDU(fimg));
        f.addHDU(Fits.makeHDU(dimg));
        f.addHDU(Fits.makeHDU(img3));
        f.addHDU(Fits.makeHDU(img1));
        Assert.assertEquals((String)"HDU count before", (long)f.getNumberOfHDUs(), (long)8L);
        BufferedFile bf = new BufferedFile("image1.fits", "rw");
        f.write(bf);
        bf.flush();
        bf.close();
        bf = null;
        f = null;
        bf = new BufferedFile("image1.fits");
        f = new Fits("image1.fits");
        BasicHDU[] hdus = f.read();
        Assert.assertEquals((String)"HDU count after", (long)f.getNumberOfHDUs(), (long)8L);
        Assert.assertEquals((String)"byte image", (Object)true, (Object)ArrayFuncs.arrayEquals(bimg, hdus[0].getData().getKernel()));
        Assert.assertEquals((String)"short image", (Object)true, (Object)ArrayFuncs.arrayEquals(simg, hdus[1].getData().getKernel()));
        Assert.assertEquals((String)"int image", (Object)true, (Object)ArrayFuncs.arrayEquals(iimg, hdus[2].getData().getKernel()));
        Assert.assertEquals((String)"long image", (Object)true, (Object)ArrayFuncs.arrayEquals(limg, hdus[3].getData().getKernel()));
        Assert.assertEquals((String)"float image", (Object)true, (Object)ArrayFuncs.arrayEquals(fimg, hdus[4].getData().getKernel()));
        Assert.assertEquals((String)"double image", (Object)true, (Object)ArrayFuncs.arrayEquals(dimg, hdus[5].getData().getKernel()));
        Assert.assertEquals((String)"int3 image", (Object)true, (Object)ArrayFuncs.arrayEquals(img3, hdus[6].getData().getKernel()));
        Assert.assertEquals((String)"double1 image", (Object)true, (Object)ArrayFuncs.arrayEquals(img1, hdus[7].getData().getKernel()));
    }

    @Test
    public void fileTest() throws Exception {
        byte[][] bimg = new byte[40][40];
        for (int i = 10; i < 30; ++i) {
            for (int j = 10; j < 30; ++j) {
                bimg[i][j] = (byte)(i + j);
            }
        }
        short[][] simg = (short[][])ArrayFuncs.convertArray(bimg, Short.TYPE);
        int[][] iimg = (int[][])ArrayFuncs.convertArray(bimg, Integer.TYPE);
        long[][] limg = (long[][])ArrayFuncs.convertArray(bimg, Long.TYPE);
        float[][] fimg = (float[][])ArrayFuncs.convertArray(bimg, Float.TYPE);
        double[][] dimg = (double[][])ArrayFuncs.convertArray(bimg, Double.TYPE);
        int[][][] img3 = new int[10][20][30];
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 20; ++j) {
                for (int k = 0; k < 30; ++k) {
                    img3[i][j][k] = i + j + k;
                }
            }
        }
        double[] img1 = (double[])ArrayFuncs.flatten(dimg);
        Fits f = new Fits(new File("image1.fits"));
        BasicHDU[] hdus = f.read();
        Assert.assertEquals((String)"fbyte image", (Object)true, (Object)ArrayFuncs.arrayEquals(bimg, hdus[0].getData().getKernel()));
        Assert.assertEquals((String)"fshort image", (Object)true, (Object)ArrayFuncs.arrayEquals(simg, hdus[1].getData().getKernel()));
        Assert.assertEquals((String)"fint image", (Object)true, (Object)ArrayFuncs.arrayEquals(iimg, hdus[2].getData().getKernel()));
        Assert.assertEquals((String)"flong image", (Object)true, (Object)ArrayFuncs.arrayEquals(limg, hdus[3].getData().getKernel()));
        Assert.assertEquals((String)"ffloat image", (Object)true, (Object)ArrayFuncs.arrayEquals(fimg, hdus[4].getData().getKernel()));
        Assert.assertEquals((String)"fdouble image", (Object)true, (Object)ArrayFuncs.arrayEquals(dimg, hdus[5].getData().getKernel()));
        Assert.assertEquals((String)"fint3 image", (Object)true, (Object)ArrayFuncs.arrayEquals(img3, hdus[6].getData().getKernel()));
        Assert.assertEquals((String)"fdouble1 image", (Object)true, (Object)ArrayFuncs.arrayEquals(img1, hdus[7].getData().getKernel()));
    }
}

