/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import java.util.List;
import nom.tam.fits.Fits;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class DupTest {
    @Test
    public void test() throws Exception {
        Fits f = new Fits("test_dup.fits");
        Header hdr = f.readHDU().getHeader();
        Assert.assertEquals((String)"Internal size:", (long)hdr.getSize(), (long)2880L);
        Assert.assertEquals((String)"External size:", (long)hdr.getOriginalSize(), (long)8640L);
        Assert.assertTrue((String)"Has duplicates:", (boolean)hdr.hadDuplicates());
        List<HeaderCard> dups = hdr.getDuplicates();
        System.out.println("Number of duplicates:" + dups.size());
        Assert.assertTrue((String)"Has dups:", (dups != null && dups.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Not rewriteable:", (!hdr.rewriteable() ? 1 : 0) != 0);
        BufferedFile bf = new BufferedFile("created_dup.fits", "rw");
        f.write(bf);
        hdr.resetOriginalSize();
        Assert.assertEquals((String)"External size, after reset", (long)hdr.getOriginalSize(), (long)2880L);
        Fits g = new Fits("created_dup.fits");
        hdr = g.readHDU().getHeader();
        Assert.assertEquals((String)"Internal size, after rewrite", (long)hdr.getSize(), (long)2880L);
        Assert.assertEquals((String)"External size, after rewrite", (long)hdr.getOriginalSize(), (long)2880L);
        Assert.assertTrue((String)"Now rewriteable", (boolean)hdr.rewriteable());
        Assert.assertTrue((String)"No duplicates", (!hdr.hadDuplicates() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Dups is null", (hdr.getDuplicates() == null ? 1 : 0) != 0);
    }
}

