/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class ImageData
extends Data {
    long byteSize;
    Object dataArray;
    ArrayDesc dataDescription;
    private ImageTiler tiler;

    public ImageData(Header h) throws FitsException {
        this.dataDescription = this.parseHeader(h);
    }

    protected ArrayDesc parseHeader(Header h) throws FitsException {
        Class<Number> baseClass;
        int gCount = h.getIntValue("GCOUNT", 1);
        int pCount = h.getIntValue("PCOUNT", 0);
        if (gCount > 1 || pCount != 0) {
            throw new FitsException("Group data treated as images");
        }
        int bitpix = h.getIntValue("BITPIX", 0);
        if (bitpix == 8) {
            baseClass = Byte.TYPE;
        } else if (bitpix == 16) {
            baseClass = Short.TYPE;
        } else if (bitpix == 32) {
            baseClass = Integer.TYPE;
        } else if (bitpix == 64) {
            baseClass = Long.TYPE;
        } else if (bitpix == -32) {
            baseClass = Float.TYPE;
        } else if (bitpix == -64) {
            baseClass = Double.TYPE;
        } else {
            throw new FitsException("Invalid BITPIX:" + bitpix);
        }
        int ndim = h.getIntValue("NAXIS", 0);
        int[] dims = new int[ndim];
        this.byteSize = 1L;
        for (int i = 0; i < ndim; ++i) {
            int cdim = h.getIntValue("NAXIS" + (i + 1), 0);
            if (cdim < 0) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            this.byteSize *= (long)cdim;
            dims[ndim - i - 1] = cdim;
        }
        this.byteSize *= (long)(Math.abs(bitpix) / 8);
        if (ndim == 0) {
            this.byteSize = 0L;
        }
        return new ArrayDesc(dims, baseClass);
    }

    public ImageData() {
        this.dataArray = new byte[0];
        this.byteSize = 0L;
    }

    public ImageData(Object x) {
        this.dataArray = x;
        this.byteSize = ArrayFuncs.computeLSize(x);
    }

    @Override
    protected void fillHeader(Header head) throws FitsException {
        int bitpix;
        if (this.dataArray == null) {
            head.nullImage();
            return;
        }
        String classname = this.dataArray.getClass().getName();
        int[] dimens = ArrayFuncs.getDimensions(this.dataArray);
        if (dimens == null || dimens.length == 0) {
            throw new FitsException("Image data object not array");
        }
        switch (classname.charAt(dimens.length)) {
            case 'B': {
                bitpix = 8;
                break;
            }
            case 'S': {
                bitpix = 16;
                break;
            }
            case 'I': {
                bitpix = 32;
                break;
            }
            case 'J': {
                bitpix = 64;
                break;
            }
            case 'F': {
                bitpix = -32;
                break;
            }
            case 'D': {
                bitpix = -64;
                break;
            }
            default: {
                throw new FitsException("Invalid Object Type for FITS data:" + classname.charAt(dimens.length));
            }
        }
        head.setSimple(true);
        head.setBitpix(bitpix);
        head.setNaxes(dimens.length);
        for (int i = 1; i <= dimens.length; ++i) {
            if (dimens[i - 1] == -1) {
                throw new FitsException("Unfilled array for dimension: " + i);
            }
            head.setNaxis(i, dimens[dimens.length - i]);
        }
        head.addValue("EXTEND", true, "ntf::imagedata:extend:1");
        head.addValue("PCOUNT", 0L, "ntf::imagedata:pcount:1");
        head.addValue("GCOUNT", 1L, "ntf::imagedata:gcount:1");
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        this.setFileOffset(i);
        if (i instanceof RandomAccess) {
            this.tiler = new ImageDataTiler((RandomAccess)i, ((RandomAccess)i).getFilePointer(), this.dataDescription);
            try {
                i.skipBytes(this.byteSize);
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip over image:" + e);
            }
        }
        this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
        try {
            i.readLArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read image data:" + e);
        }
        this.tiler = new ImageDataTiler(null, 0L, this.dataDescription);
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            i.skipBytes(pad);
        }
        catch (EOFException e) {
            throw new PaddingException("Error skipping padding after image", this);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding after image");
        }
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        if (this.dataArray == null) {
            if (this.tiler != null) {
                try {
                    this.dataArray = this.tiler.getCompleteImage();
                }
                catch (IOException e) {
                    throw new FitsException("Error attempting to fill image");
                }
            } else if (this.dataArray == null && this.dataDescription != null) {
                this.dataArray = ArrayFuncs.newInstance(this.dataDescription.type, this.dataDescription.dims);
            } else {
                throw new FitsException("Null image data");
            }
        }
        try {
            o.writeArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on image write" + e);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    @Override
    public Object getData() {
        if (this.dataArray == null && this.tiler != null) {
            try {
                this.dataArray = this.tiler.getCompleteImage();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.dataArray;
    }

    void setTiler(ImageTiler tiler) {
        this.tiler = tiler;
    }

    public ImageTiler getTiler() {
        return this.tiler;
    }

    protected class ImageDataTiler
    extends ImageTiler {
        ImageDataTiler(RandomAccess o, long offset, ArrayDesc d) {
            super(o, offset, d.dims, d.type);
        }

        @Override
        public Object getMemoryImage() {
            return ImageData.this.dataArray;
        }
    }

    protected class ArrayDesc {
        int[] dims;
        Class type;

        ArrayDesc(int[] dims, Class type) {
            this.dims = dims;
            this.type = type;
        }
    }
}

