/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.Cursor;

public abstract class BasicHDU
implements FitsElement {
    public static final int BITPIX_BYTE = 8;
    public static final int BITPIX_SHORT = 16;
    public static final int BITPIX_INT = 32;
    public static final int BITPIX_LONG = 64;
    public static final int BITPIX_FLOAT = -32;
    public static final int BITPIX_DOUBLE = -64;
    protected Header myHeader = null;
    protected Data myData = null;
    protected boolean isPrimary = false;

    abstract Data manufactureData() throws FitsException;

    public static void skipData(ArrayDataInput stream, Header hdr) throws IOException {
        stream.skipBytes(hdr.getDataSize());
    }

    public void skipData(ArrayDataInput stream) throws IOException {
        BasicHDU.skipData(stream, this.myHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(ArrayDataInput stream) throws FitsException {
        this.myData = null;
        try {
            this.myData = this.manufactureData();
        }
        finally {
            if (this.myData == null) {
                try {
                    BasicHDU.skipData(stream, this.myHeader);
                }
                catch (Exception exception) {}
            }
        }
        this.myData.read(stream);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    @Override
    public long getFileOffset() {
        return this.myHeader.getFileOffset();
    }

    public Data getData() {
        return this.myData;
    }

    public Object getKernel() {
        try {
            return this.myData.getKernel();
        }
        catch (FitsException e) {
            return null;
        }
    }

    @Override
    public long getSize() {
        int size = 0;
        if (this.myHeader != null) {
            size = (int)((long)size + this.myHeader.getSize());
        }
        if (this.myData != null) {
            size = (int)((long)size + this.myData.getSize());
        }
        return size;
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public abstract void info();

    boolean checkField(String name) {
        String value = this.myHeader.getStringValue(name);
        return value != null;
    }

    @Override
    public void read(ArrayDataInput stream) throws FitsException, IOException {
        this.myHeader = Header.readHeader(stream);
        this.myData = this.myHeader.makeData();
        this.myData.read(stream);
    }

    @Override
    public void write(ArrayDataOutput stream) throws FitsException {
        if (this.myHeader != null) {
            this.myHeader.write(stream);
        }
        if (this.myData != null) {
            this.myData.write(stream);
        }
        try {
            stream.flush();
        }
        catch (IOException e) {
            throw new FitsException("Error flushing at end of HDU: " + e.getMessage());
        }
    }

    @Override
    public boolean rewriteable() {
        return this.myHeader.rewriteable() && this.myData.rewriteable();
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite HDU");
        }
        this.myHeader.rewrite();
        this.myData.rewrite();
    }

    public String getTrimmedString(String keyword) {
        String s = this.myHeader.getStringValue(keyword);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public int getBitPix() throws FitsException {
        int bitpix = this.myHeader.getIntValue("BITPIX", -1);
        switch (bitpix) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new FitsException("Unknown BITPIX type " + bitpix);
            }
        }
        return bitpix;
    }

    public int[] getAxes() throws FitsException {
        int nAxis = this.myHeader.getIntValue("NAXIS", 0);
        if (nAxis < 0) {
            throw new FitsException("Negative NAXIS value " + nAxis);
        }
        if (nAxis > 999) {
            throw new FitsException("NAXIS value " + nAxis + " too large");
        }
        if (nAxis == 0) {
            return null;
        }
        int[] axes = new int[nAxis];
        for (int i = 1; i <= nAxis; ++i) {
            axes[nAxis - i] = this.myHeader.getIntValue("NAXIS" + i, 0);
        }
        return axes;
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue("PCOUNT", 0);
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue("GCOUNT", 1);
    }

    public double getBScale() {
        return this.myHeader.getDoubleValue("BSCALE", 1.0);
    }

    public double getBZero() {
        return this.myHeader.getDoubleValue("BZERO", 0.0);
    }

    public String getBUnit() {
        return this.getTrimmedString("BUNIT");
    }

    public int getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey("BLANK")) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getIntValue("BLANK");
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE")).toDate();
        }
        catch (FitsException e) {
            return null;
        }
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE-OBS")).toDate();
        }
        catch (FitsException e) {
            return null;
        }
    }

    public String getOrigin() {
        return this.getTrimmedString("ORIGIN");
    }

    public String getTelescope() {
        return this.getTrimmedString("TELESCOP");
    }

    public String getInstrument() {
        return this.getTrimmedString("INSTRUME");
    }

    public String getObserver() {
        return this.getTrimmedString("OBSERVER");
    }

    public String getObject() {
        return this.getTrimmedString("OBJECT");
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue("EQUINOX", -1.0);
    }

    public double getEpoch() {
        return this.myHeader.getDoubleValue("EPOCH", -1.0);
    }

    public String getAuthor() {
        return this.getTrimmedString("AUTHOR");
    }

    public String getReference() {
        return this.getTrimmedString("REFERENC");
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue("DATAMAX");
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue("DATAMIN");
    }

    boolean canBePrimary() {
        return false;
    }

    @Override
    public boolean reset() {
        return this.myHeader.reset();
    }

    void setPrimaryHDU(boolean newPrimary) throws FitsException {
        HeaderCard card;
        if (newPrimary && !this.canBePrimary()) {
            throw new FitsException("Invalid attempt to make HDU of type:" + this.getClass().getName() + " primary.");
        }
        this.isPrimary = newPrimary;
        if (this.isPrimary && !this.myHeader.getBooleanValue("GROUPS", false)) {
            this.myHeader.deleteKey("PCOUNT");
            this.myHeader.deleteKey("GCOUNT");
        }
        if (this.isPrimary && (card = this.myHeader.findCard("EXTEND")) == null) {
            this.getAxes();
            this.myHeader.nextCard();
            this.myHeader.addValue("EXTEND", true, "ntf::basichdu:extend:1");
        }
        if (!this.isPrimary) {
            Cursor iter = this.myHeader.iterator();
            int pcount = this.myHeader.getIntValue("PCOUNT", 0);
            int gcount = this.myHeader.getIntValue("GCOUNT", 1);
            int naxis = this.myHeader.getIntValue("NAXIS", 0);
            this.myHeader.deleteKey("EXTEND");
            HeaderCard pcard = this.myHeader.findCard("PCOUNT");
            HeaderCard gcard = this.myHeader.findCard("GCOUNT");
            this.myHeader.getCard(2 + naxis);
            if (pcard == null) {
                this.myHeader.addValue("PCOUNT", pcount, "ntf::basichdu:pcount:1");
            }
            if (gcard == null) {
                this.myHeader.addValue("GCOUNT", gcount, "ntf::basichdu:gcount:1");
            }
            Cursor cursor = this.myHeader.iterator();
        }
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, int val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public static BasicHDU getDummyHDU() {
        try {
            ImageData img = new ImageData((Object)null);
            return FitsFactory.HDUFactory(ImageHDU.manufactureHeader(img), img);
        }
        catch (FitsException e) {
            System.err.println("Impossible exception in getDummyHDU");
            return null;
        }
    }
}

